DELIMITER $$ 

CREATE TRIGGER updstatus after UPDATE ON field_data_field_ticket_status    		
     FOR EACH ROW
     BEGIN
		 IF new.field_ticket_status_tid <> OLD.field_ticket_status_tid THEN
			SET @orden = NEW.entity_id;
			SET @estado = (SELECT name from taxonomy_term_data where tid = NEW.field_ticket_status_tid);
			SET @falla = (SELECT title from node where nid = @orden);
			SET @ciente_id = (SELECT field_cliente_target_id FROM field_data_field_cliente where entity_id=@orden); 
			SET @ciente = (SELECT name FROM users where uid=@cliente_id);   
			SET @email_ciente = (SELECT email FROM users where uid=@cliente_id);
			SET @texto_email = (SELECT concat('Estimado ',@cliente, ', La orden # ', @orden, '(',@falla,') ha sido actualizada a estado: ', @estado));
			insert into notification_queue (sent, email_to,texto_email) values (0,@email_ciente,@texto_email);
		 END IF;
     END$$
DELIMITER ;
